define([
    'underscore',
    'marionette',
    'App',

    'modules/appointments/appointments-radio',

    'modules/appointments/booked/booked-appointment-view',
    'modules/appointments/requested/requested-appointment-view',
],
function (
    _,
    Marionette,
    app,

    radio,

    BookedAppointmentView,
    RequestedAppointmentView
) {
    'use strict';

    var AppointmentsRouter = Marionette.AppRouter.extend({
        controller: new (Marionette.Object.extend({
            showAppointmentDetailsFromModel: function(model, options) {
                app.show(new BookedAppointmentView(_.extend({model: model}, options)));
            },
            showRequestDetailsFromModel: function(model, options) {
                app.show(new RequestedAppointmentView(_.extend({model: model}, options)));
            },
        }))(),
    });

    var appointmentsRouter = new AppointmentsRouter();

    radio.on('appointments:appointment:selected', function(model, options) {
        appointmentsRouter.controller.showAppointmentDetailsFromModel(model, options);

        // id not available
        // adding to history but does not correspond to route
        appointmentsRouter.navigate('appointment/booked-details');
    }, appointmentsRouter.controller);

    radio.on('appointments:request:selected', function(model, options) {
        appointmentsRouter.controller.showRequestDetailsFromModel(model, options);

        // adding to history but does not correspond to route
        appointmentsRouter.navigate('appointment/request-details/');
    }, appointmentsRouter.controller);

    return appointmentsRouter;
});
